<?php

namespace App/Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ArrivalTransferPattern extends Eloquent {

	protected $table = 'arrival_transfer_pattern';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('arrival_answer_id', 'name', 'number_of_pilgrim');

	public function arrival_answer()
	{
		return $this->belongsTo('App/Model\ArrivalAnswer');
	}

}