<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function created_by_user()
    {
        return $this->belongsTo('Groups', 'created_by');
    }

    public function group_user()
    {
        return $this->hasMany('GroupUser', 'user_id');
    }

    public function forumCreatedBy()
    {
        return $this->hasMany('Forums', 'created_by');
    }

}