<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonTable extends Migration {

	public function up()
	{
		Schema::create('person', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('email_address', 120)->unique();
			$table->string('password', 128);
			$table->binary('password_change_required');
			$table->string('first_name', 50);
			$table->string('last_name', 50);
			$table->date('birthday');
			$table->enum('person_type', array('human', 'club', 'corporation', 'non-profit'));
			$table->string('address1', 80);
			$table->string('address2');
			$table->string('address3', 80);
			$table->string('city', 80);
			$table->string('state_province', 80);
			$table->string('zip_postcode', 10);
			$table->string('country', 80);
			$table->string('primary_phone_country_code', 3)->default('1');
			$table->string('primary_phone_number', 10);
			$table->boolean('primary_phone_receives_SMS');
			$table->string('alternate_phone_country_code', 3)->default('1');
			$table->string('alternate_phone_number', 10);
			$table->boolean('alternate_phone_receives_SMS');
		});
	}

	public function down()
	{
		Schema::drop('person');
	}
}