<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMembersTable extends Migration {

	public function up()
	{
		Schema::create('members', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('person_id')->unsigned();
			$table->enum('membership_type', array('regular', 'senior', 'lifetime'));
			$table->date('membership_expiration');
			$table->integer('primary_member_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('members');
	}
}