<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHotelsTable extends Migration {

	public function up()
	{
		Schema::create('hotels', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 250);
			$table->string('address', 250);
			$table->text('description')->nullable();
			$table->string('phone', 20)->nullable();
			$table->string('mobile', 20)->nullable();
			$table->string('fax', 20)->nullable();
			$table->string('email', 250);
			$table->integer('location');
			$table->integer('stars');
			$table->integer('timezone');
			$table->string('image', 250)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('hotels');
	}
}