<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->text('description')->nullable();
			$table->string('booking_number', 20);
			$table->integer('payment_type');
			$table->integer('payment_method');
			$table->decimal('price');
			$table->decimal('vat');
			$table->decimal('payment');
			$table->decimal('pre_payment');
			$table->decimal('additional_payment');
			$table->integer('payment_status');
			$table->datetime('check_in')->nullable();
			$table->datetime('check_out')->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}