<?php

namespace App\Entities\Users;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'email', 'password');
	protected $hidden = array('password');

	public function profile()
	{
		return $this->hasOne('Profile');
	}

	public function enrollments()
	{
		return $this->hasMany('Enrolment');
	}

	public function invoices()
	{
		return $this->hasMany('Invoice');
	}

	public function notifications()
	{
		return $this->hasMany('Notification');
	}

	public function bookings()
	{
		return $this->hasMany('Booking');
	}

}