<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('owner_id')->unsigned();
			$table->integer('city_id');
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->string('image')->nullable();
			$table->string('location')->nullable();
			$table->bigInteger('capacity')->nullable();
			$table->boolean('is_active')->nullable()->default(0);
			$table->boolean('has_volunteer')->nullable()->default(0);
			$table->boolean('has_guests')->nullable()->default(0);
			$table->datetime('start_at')->nullable();
			$table->datetime('end_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}