<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class VolunteerOrganize extends Eloquent {

	protected $table = 'volunteer_organizes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('requirement_answer_id', 'orgnize_name_ar', 'orgnize_name_en', 'hours', 'location');

	public function requirement_answer()
	{
		return $this->belongsTo('App\Models\RequirementAnswer');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

}