<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'phone', 'email', 'password', 'is_active', 'is_approved', 'is_suspend');

	public function type()
	{
		return $this->belongsTo('App\Models\Type');
	}

}