<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TypeRequirement extends Eloquent {

	protected $table = 'type_requirements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('type_id', 'requirement_id');

	public function type()
	{
		return $this->belongsTo('App\Models\Type');
	}

	public function requirement()
	{
		return $this->belongsTo('App\Models\Requirement');
	}

}