<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50)->unique();
			$table->string('email')->unique();
			$table->string('password', 60);
			$table->timestamps();
			$table->date('verified')->nullable();
			$table->date('disabled')->nullable();
			$table->string('remember_token', 100)->unique()->nullable();
			$table->string('verify_token', 60)->unique()->nullable();
			$table->date('verify_token_last_date')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}