<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model 
{

    protected $table = 'Invoices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function invoiceItems()
    {
        return $this->hasMany('InvoiceItem');
    }

    public function order()
    {
        return $this->belongsTo('Order');
    }

}