<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePeopleTable extends Migration {

	public function up()
	{
		Schema::create('people', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('email')->unique();
			$table->string('cpf_cnpj', 14)->unique();
			$table->string('crea_cau', 13)->unique()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('people');
	}
}