<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('vendor_id')->unsigned()->nullable();
			$table->integer('branch_id')->unsigned()->nullable();
			$table->integer('service_category_id')->unsigned()->nullable();
			$table->integer('service_id')->unsigned()->nullable();
			$table->enum('all', array('1', '2'));
			$table->enum('discount_type', array('1', '2'));
			$table->boolean('discount_amount');
			$table->date('start_date');
			$table->date('end_date');
			$table->integer('max_use');
			$table->integer('uses');
			$table->enum('status', array('1', '2'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}