<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorsTable extends Migration {

	public function up()
	{
		Schema::create('vendors', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 150);
			$table->string('phone', 55)->unique();
			$table->string('whatsapp_number', 55)->nullable();
			$table->string('email', 100)->nullable();
			$table->string('password', 100);
			$table->string('address_lat', 55)->nullable();
			$table->string('address_long', 55)->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->string('commercial_register', 55)->unique();
			$table->enum('target_client_gender', array('1', '2', '3'));
			$table->integer('vendor_type')->unsigned();
			$table->integer('package_id')->unsigned();
			$table->double('commission_rate');
			$table->integer('otp')->nullable();
			$table->enum('status', array('1', '2', '3'));
			$table->enum('classification', array('1', '2'));
			$table->enum('term_acceptance', array('1', '2'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('vendors');
	}
}