<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('phone', 55)->nullable();
			$table->string('email', 100)->nullable();
			$table->string('whatsapp', 55)->nullable();
			$table->string('facebook', 100)->nullable();
			$table->string('banner', 150)->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 150);
			$table->text('note')->nullable();
			$table->string('image', 150)->nullable();
			$table->string('video', 150)->nullable();
			$table->string('address_lat', 55)->nullable();
			$table->string('address_long', 55)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}